/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 15.5)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 *
 *  Uyj #define MAIN aby skompilowa wersj testow.
 */

#include <stdio.h>
#ifndef VARARGS
#include <stdarg.h>

#ifdef __STDC__
void error(char *fmt, ...)
#else
void error(fmt)
char *fmt;
#endif
{
	va_list argp;
	fprintf(stderr, "bd: ");
	va_start(argp, fmt);
	vfprintf(stderr, fmt, argp);
	va_end(argp);
	fprintf(stderr, "\n");
}
#else
#include <varargs.h>

void error(va_alist)
va_dcl		/* bez rednika */
	{
	char *fmt;
	va_list argp;
	fprintf(stderr, "bd: ");
	va_start(argp);
	fmt = va_arg(argp, char *);
	vfprintf(stderr, fmt, argp);
	va_end(argp);
	fprintf(stderr, "\n");
}
#endif
#ifdef MAIN

main()
{
	error("Witaj, wiecie!");
	error("%d != %s", 1, "dwa");
	return 0;
}

#endif
